//---------------------------------------------------------------
// Proiect    : Electronica Digitala
//              Carte de invatatura
// Autor      : Dan NICULA 
// An         : 2025
//---------------------------------------------------------------
// Descriere  : Circuit de determinare a maximului din 3
//                cu interfata valid-ready, combinational
//---------------------------------------------------------------

module max3_test #(
parameter CK_SEMIPERIOD = 10  ,
parameter DW            = 8     // Data width;
);

wire              clk         ;
wire              rst_n       ;
reg               client_val  ;
wire              client_rdy  ;      
reg   [3*DW -1:0] client_data ;

wire              max_val     ;
reg               max_rdy     ;
wire   [DW  -1:0] max_data    ;

ck_rst_tb #(
.CK_SEMIPERIOD (CK_SEMIPERIOD)
) i_ck_rst_tb (
.clk        (clk      ),
.rst_n      (rst_n    )
); 
     
//max3_2 #(
//max3_1 #(
max3_0 #(
.DW (DW)
) i_max3(
.clk         (clk        ), 
.rst_n       (rst_n      ), 
.client_val  (client_val ), 
.client_rdy  (client_rdy ),   
.client_data (client_data), 
.max_val     (max_val    ), 
.max_rdy     (max_rdy    ), 
.max_data    (max_data   )  
);

vld_rdy_checker #(
.DW  (3*DW    )
) client_vld_rdy_checker (     
.clk                (clk          ),
.valid              (client_val   ),  
.ready              (client_rdy   ),                   
.data               (client_data  )                                                                                                                                                                         
);

vld_rdy_checker #(
.DW  (DW    )
) max_vld_rdy_checker (     
.clk                (clk          ),
.valid              (max_val      ),  
.ready              (max_rdy      ),                   
.data               (max_data     )                                                                                                                                                                        
);

/// client initiator
initial begin
  // asteptare reset asincron
  client_val  <= 1'bx;
  client_data <= 'bx;  
  @(negedge rst_n);
  client_val  <= 1'b0;
  @(posedge rst_n);
  @(posedge clk);
  
  forever begin
    if ($urandom_range(0,4)<4) begin
      client_val  <= 1'b1;
      client_data <= $urandom_range(0,(1<<3*DW));
      @(posedge clk);
      while (~client_rdy) @(posedge clk);
    end
    else begin
      client_val  <= 1'b0;
      client_data <= 'bx;
      @(posedge clk);
    end
  end
end

// client max
initial begin
  max_rdy  <= 1'bx;
  @(negedge rst_n);
  max_rdy  <= 1'b0;
  @(posedge rst_n);
  @(posedge clk);
  
  forever begin
    max_rdy  <= ($urandom_range(0,10)<10);
    @(posedge clk);
  end
end

integer   file_src_id  ; // handler fisier
integer   file_dst_id  ; // handler fisier
  
initial begin
  // src
  file_src_id   = $fopen("output_data/src.txt", "w");
  if (file_src_id == 0) begin
    $display("Nu se poate deschide fisier src.txt");
    $stop;
  end
  forever  begin
    if (client_val & client_rdy)
      $fwrite(file_src_id,"%h \n", client_data);
    @(posedge clk);
  end
end

initial begin
  // src
  file_dst_id   = $fopen("output_data/dst.txt", "w");
  if (file_dst_id == 0) begin
    $display("Nu se poate deschide fisier dst.txt");
    $stop;
  end
  forever  begin
    if (max_val & max_rdy)
      $fwrite(file_dst_id,"%h \n", max_data);
    @(posedge clk);
  end
end


endmodule // max3_test

