//---------------------------------------------------------------
// Proiect    : Electronica Digitala
//              Carte de invatatura
// Autor      : Dan NICULA 
// An         : 2025
//---------------------------------------------------------------
// Descriere  : Circuit de determinare a maximului din 3
//                cu interfata valid-ready, combinational
//---------------------------------------------------------------

module max3_0 #(
parameter DW = 'd4 // Data width, numar de biti ai operanzilor 
)(
input               clk         , // semnal de ceas, 
input               rst_n       , // reset asincron activ 0
// interfata client
input               client_val  , 
output              client_rdy  ,             
input [3*DW -1:0]   client_data , // 3 date de cate DW biti
// interfata maxim
output              max_val     , // 
input               max_rdy     , // 
output  [DW  -1:0]  max_data      // maximul, DW biti
);

wire [DW  -1:0]   data0   ;
wire [DW  -1:0]   data1   ;
wire [DW  -1:0]   data2   ;
wire [DW  -1:0]   max_0_1 ;

assign data0 = client_data[   0+:DW];
assign data1 = client_data[  DW+:DW];
assign data2 = client_data[2*DW+:DW];

assign max_val    = client_val;
assign client_rdy = max_rdy   ;
assign max_0_1    = data0   > data1 ? data0   : data1;
assign max_data   = max_0_1 > data2 ? max_0_1 : data2;

endmodule // max3_0

