//---------------------------------------------------------------
// Proiect    : Electronica Digitala
//              Carte de invatatura
// Autor      : Dan NICULA 
// An         : 2025
//---------------------------------------------------------------
// Descriere  : Verificator protocol valid-ready
//---------------------------------------------------------------

module vld_rdy_checker #(
parameter         DW  = 8    // Data width;
)     
(     
input             clk    ,                             
input             valid  ,                                                                           
input             ready  ,                                                                           
input [DW - 1: 0] data    
);                                                        
reg              ready_del  ;
reg              valid_del  ;
reg [DW - 1: 0]  data_del   ;

always @(posedge clk) begin
  ready_del <=  ready ;
  valid_del <=  valid ;
  data_del  <=  data  ;
end

always @(posedge clk) begin
  // [ ] valid != 0 or 1
  if ((valid !== 1'b0) & (valid !== 1'b1)) 
    $display("%M %0t VLD-RDY ERROR: VLD = x.", $time);

  // [ ] ready != 0 or 1
  if ((ready !== 1'b0) & (ready !== 1'b1)) 
    $display("%M %0t VLD-RDY ERROR: READY = x.", $time);
 
  // [ ] vld    --|__
  //     ready  __|xx
  if (valid_del & ~valid & ~ready_del ) 
    $display("%M %0t VLD-RDY ERROR: VALID deactivated wrong.", $time);
  
  // [ ] vld    -----
  //     ready  _____
  //     data    __|--
  if (valid_del & valid & ~ready_del & (data !== data_del)) 
    $display("%M %0t VLD-RDY ERROR: DATA changed during VALID without RDY.", $time);

  // [ ] vld    -----
  //     data   xxxx
  if (valid & $isunknown(data)) 
    $display("%M %0t VLD-RDY ERROR: DATA is X during VALID.", $time);

end

endmodule // vld_rdy_checker
